package w83a.w83aOperacionesPaso.w83aResultados;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import w83a.w83aBeans.W83aResultadosBean;
import w83a.w83aBeans.W83aUsuarioXLNetsBean;
import w83a.w83aUtilidades.W83aUtilidadesComunes;
import w83a.w83aUtilidades.W83aUtilidadesPdf;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import w83a.w83aUtilidadesComunes.W83aUtilidades;
import w83a.w83aUtilidadesComunes.W83aUtilidadesN38API;
import com.lowagie.text.Document;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83aTablaResCentroSindPdfAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		List lista = (ArrayList)contexto.get("w83aListadoResultadosBean");
	    W83aResultadosBean resultadoBean = (W83aResultadosBean)contexto.get("w83aResultadosBean");
        String idioma = (String)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        W83aUsuarioXLNetsBean usuario = (W83aUsuarioXLNetsBean)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83aUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets()); 
		
		Paragraph parrafo;
		Document document = new Document();			

	
		document = new Document(PageSize.A4.rotate()); //Creo un documento 		
		document.setMargins(20, 20, 80, 40);						

		PdfWriter.getInstance(document, response.getOutputStream());		
		response.setContentType("application/pdf");		
    	response.setHeader("Content-Disposition", "attachment;filename=DetalleCentroSindicato.pdf;");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        response.setStatus(HttpServletResponse.SC_OK);
        
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance(document, baos);	
	    
        //Evento para cabecera de pgina
		Rectangle rct = new Rectangle(54, 36, 788 , 589);
        writer.setBoxSize("art", rct);
        
        W83aUtilidadesPdf.HeaderFooter event = new W83aUtilidadesPdf.HeaderFooter(idioma, usuario.getCalleListadosFormateada());
        writer.setPageEvent(event);
		
		document.open();
		int contador=0;
		
		PdfPTable table;
		Font fonttitulo = FontFactory.getFont("Arial", 12, Font.BOLD);
		Font fontbold = FontFactory.getFont("Arial", 7, Font.BOLD);
		//Font fontnormal = FontFactory.getFont("Arial", 9, Font.NORMAL);
		Font fontnormalpeq = FontFactory.getFont("Arial", 7, Font.NORMAL);
		PdfPCell cell;
		
		parrafo=new Paragraph(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.detalleResultados",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.detalleResultados",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fonttitulo);
        parrafo.setAlignment(Rectangle.ALIGN_CENTER);
        document.add(parrafo);
        if(StringUtils.isNotEmpty(resultadoBean.getFechaHistorico())){
        	parrafo=new Paragraph(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}),fontnormalpeq);
        	parrafo.setAlignment(Rectangle.ALIGN_CENTER);
        	document.add(parrafo);
        }
        parrafo=new Paragraph(" ");
        document.add(parrafo);
		
		table=new PdfPTable(6);
        table.setWidthPercentage(100);
        
        
        float[] columnWidths = {0.15f, 1.50f, 0.75f, 0.5f, 1.60f, 2f};

        table.setWidths(columnWidths);
        
        cell = new PdfPCell(new Phrase(""));
    	cell.setBorder(0);
    	table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numregdefdesde",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numregdefdesde",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        cell.setBorder(0);
        table.addCell(cell);
        if(StringUtils.isEmpty(resultadoBean.getAnoRegDefDesde())){
        	resultadoBean.setAnoRegDefDesde("-");
        }
		
		StringBuffer sb=new StringBuffer(W83aClsConstantes.SEIS);//NOPMD
		
		if(StringUtils.isEmpty(resultadoBean.getNumRegDefDesde())){
			sb.append("-");
		}else{
			String valor=W83aUtilidadesComunes.rellenarCeros(resultadoBean.getNumRegDefDesde());
			sb.append(valor);
		}
		cell = new PdfPCell(new Phrase(resultadoBean.getTerritActaDesde()+"/"+resultadoBean.getAnoRegDefDesde()+"/"+sb.toString(),fontnormalpeq));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numregdefhasta",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numregdefhasta",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
    	cell.setBorder(0);
    	table.addCell(cell);
    	if(StringUtils.isEmpty(resultadoBean.getAnoRegDefHasta())){
        	resultadoBean.setAnoRegDefHasta("-");
        }
		
		sb=new StringBuffer(W83aClsConstantes.SEIS);//NOPMD
		if(StringUtils.isEmpty(resultadoBean.getNumRegDefHasta())){
			sb.append("-");
		}else{
			String valor=W83aUtilidadesComunes.rellenarCeros(resultadoBean.getNumRegDefHasta());
			sb.append(valor);
		} 
    	cell = new PdfPCell(new Phrase(resultadoBean.getTerritActaDesde()+"/"+resultadoBean.getAnoRegDefHasta()+"/"+sb.toString(),fontnormalpeq));
    	cell.setBorder(0);
    	table.addCell(cell);
    	
        cell = new PdfPCell(new Phrase(""));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numactadesde",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numactadesde",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
    	cell.setBorder(0);
    	table.addCell(cell);
    	if(StringUtils.isEmpty(resultadoBean.getAnoActaDesde())){
        	resultadoBean.setAnoActaDesde("-");
        }
        sb=new StringBuffer(W83aClsConstantes.SEIS);//NOPMD
		if ("".equals(resultadoBean.getNumActaDesde())){
			sb.append("-");
		}else{
			String valor=W83aUtilidadesComunes.rellenarCeros(resultadoBean.getNumActaDesde());
			sb.append(valor);
		} 
		cell = new PdfPCell(new Phrase(resultadoBean.getTerritActaDesde()+"/"+resultadoBean.getAnoActaDesde()+"/"+sb.toString(),fontnormalpeq));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numactahasta",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.numactahasta",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
    	cell.setBorder(0);
    	table.addCell(cell);
    	if(StringUtils.isEmpty(resultadoBean.getAnoActaHasta())){
           	resultadoBean.setAnoActaHasta("-");
        }
		sb=new StringBuffer(W83aClsConstantes.SEIS);//NOPMD
		if(StringUtils.isEmpty(resultadoBean.getNumActaHasta())){
			sb.append("-");
		}else{
			String valor=W83aUtilidadesComunes.rellenarCeros(resultadoBean.getNumActaHasta());
			sb.append(valor);
		} 
		cell = new PdfPCell(new Phrase(resultadoBean.getTerritActaDesde()+"/"+resultadoBean.getAnoActaHasta()+"/"+sb.toString(),fontnormalpeq));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.certificaciones.fechaEleccionDesde",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.certificaciones.fechaEleccionDesde",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
    	cell.setBorder(0);
    	table.addCell(cell);
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionDesde())){
    		cell = new PdfPCell(new Phrase(resultadoBean.getFechaEleccionDesde(),fontnormalpeq));
        }
    	else{
   		 	cell = new PdfPCell(new Phrase(""));
   	 	}
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(""));
    	cell.setBorder(0);
    	table.addCell(cell);
    	cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.certificaciones.fechaEleccionHasta",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.certificaciones.fechaEleccionHasta",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
    	cell.setBorder(0);
    	table.addCell(cell);
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionHasta())){
    		cell = new PdfPCell(new Phrase(resultadoBean.getFechaEleccionHasta(),fontnormalpeq));
        }
    	else{
   		 	cell = new PdfPCell(new Phrase(""));
   	 	}
    	cell.setBorder(0);
    	table.addCell(cell);
    	
    	document.add(table);
    	
    	
    	parrafo=new Paragraph(" ",fontbold);
    	document.add(parrafo);
        
        table=new PdfPTable(20);
        table.setWidthPercentage(100);
        
        columnWidths = new float[]{1.4f, 1.4f, 1.05f, 1.1f, 0.65f, 3.1f, 0.9f, 3.1f, 0.7f, 0.6f, 0.7f, 0.6f, 0.6f, 0.6f, 0.6f, 0.6f, 0.6f, 0.6f, 0.7f, 0.9f};

        table.setWidths(columnWidths);
        
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.nentrada",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.nentrada",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.nregistro",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.nregistro",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.feleccion",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.feleccion",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.nif",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.nif",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.sect",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.sect",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.centroTrabajo.razonSocial",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.centroTrabajo.razonSocial",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.ncent",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.ncent",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.convenio",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.convenio",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.nelec",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.nelec",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.ela",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.ela",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.ccoo",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.ccoo",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.ugt",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.ugt",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.lab",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.lab",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.uso",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.uso",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.esk",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.esk",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.cti",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.cti",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.csicsif",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.csicsif",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.nosin",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.nosin",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.otrosInf",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.resultados.otrosInf",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));
        estiloCabecera(cell);
        table.addCell(cell);
        cell = new PdfPCell(new Phrase(Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.total",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.actas.total",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase(),fontbold));   
        estiloCabecera(cell);
        table.addCell(cell);
        
        contador=contador+1;
        
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)

        String acta="";
        int otros=0;
        int total=0;
        int totalELA=0;
        int totalCCOO=0;
        int totalUGT=0;
        int totalLAB=0;
        int totalUSO=0;
        int totalCUIS=0;
        int totalCTS=0;
        int totalCSI=0;
        int totalNOSIN=0;
        int totalOTROS=0;
        int totalElec=0;
        int anno=0;
        
        int tELA=0;
        int tCCOO=0;
        int tUGT=0;
        int tLAB=0;
        int tUSO=0;
        int tCUIS=0;
        int tCTS=0;
        int tCSI=0;
        int tNOSIN=0;
        PdfPCell[] cells;
        HashMap mapa = new HashMap();
		mapa.put("idioma", (String)contexto.get(W83aClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		mapa.put("querie", "resCentroSindicato");
		sb=new StringBuffer(W83aClsConstantes.SEIS);//NOPMD
        for(int i=0;i<lista.size();i++){
        	W83aResultadosBean bean = new W83aResultadosBean().rowToBean((HashMap)lista.get(i),mapa);//NOPMD
        	if (bean.getCodsindicato()!=null){
        		if (!acta.equals(bean.getNacta())||anno!=Integer.parseInt(bean.getAnoacta())){
        			if (i>0){
        				cells=(PdfPCell[])table.getRow(contador-1).getCells();
        				cells[19].setPhrase(new Phrase(W83aUtilidades.separadorMiles(total),fontnormalpeq));//NOPMD
        			}

	        		total=0;
	        		otros=0;
	        		tELA=0;
	                tCCOO=0;
	                tUGT=0;
	                tLAB=0;
	                tUSO=0;
	                tCUIS=0;
	                tCTS=0;
	                tCSI=0;
	                tNOSIN=0;
	      
	            	sb=new StringBuffer(W83aClsConstantes.SEIS);//NOPMD
	            	String valor=W83aUtilidadesComunes.rellenarCeros(bean.getNacta());
	    			sb.append(valor);
	            	cell = new PdfPCell(new Phrase(bean.getTerritorio()+"/"+bean.getAnoacta()+"/"+sb.toString(),fontnormalpeq));//NOPMD
	            	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
	                cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	                table.addCell(cell);
	      
	            	sb=new StringBuffer(W83aClsConstantes.SEIS);//NOPMD
	            	if (bean.getNregdef()!=null){
	            		valor=W83aUtilidadesComunes.rellenarCeros(bean.getNregdef());
	        			sb.append(valor);
	            	}
	            	else{
	            		sb.append("-");
	            	}
	            	if (bean.getAnoregdef()==null){
	            		bean.setAnoregdef("-");
	            	}
	            	
	            	if(StringUtils.isNotEmpty(bean.getTerritorio()) &&
	            			StringUtils.isNotEmpty(bean.getAnoregdef()) ){
	            		cell = new PdfPCell(new Phrase(bean.getTerritorio()+"/"+bean.getAnoregdef()+"/"+sb.toString(),fontnormalpeq));//NOPMD
	            	}
	            	else{
	            		cell = new PdfPCell(new Phrase(""));//NOPMD
	            	}
	            	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
	                cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	            	table.addCell(cell);
	            	if(StringUtils.isNotEmpty(bean.getFelec())){
	            		cell = new PdfPCell(new Phrase(bean.getFelec(),fontnormalpeq));//NOPMD
	            	}
	            	else{
	            		cell = new PdfPCell(new Phrase(""));//NOPMD
	            	}
	            	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
	                cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	            	table.addCell(cell);
	            	if(StringUtils.isNotEmpty(bean.getCif())){
	            		cell = new PdfPCell(new Phrase(bean.getCif(),fontnormalpeq));//NOPMD
	            	}
	            	else{
	            		cell = new PdfPCell(new Phrase(""));//NOPMD
	            	}
	            	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
	                cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	            	table.addCell(cell);
	            	if(StringUtils.isNotEmpty(bean.getSector())){
	            		cell = new PdfPCell(new Phrase(bean.getSector(),fontnormalpeq));//NOPMD
	            	}
	            	else{
	            		cell = new PdfPCell(new Phrase(""));//NOPMD
	            	}
	            	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
	                cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	            	table.addCell(cell);
	            	if(StringUtils.isNotEmpty(bean.getRazon())){
	            		cell = new PdfPCell(new Phrase(bean.getRazon(),fontnormalpeq));//NOPMD
	            		cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	            	}
	            	else{
	            		cell = new PdfPCell(new Phrase(""));//NOPMD
	            	}
	            	table.addCell(cell);
	            	if(StringUtils.isNotEmpty(bean.getNcentro())){
	            		cell = new PdfPCell(new Phrase(bean.getNcentro(),fontnormalpeq));//NOPMD
	            	}
	            	else{
	            		cell = new PdfPCell(new Phrase(""));//NOPMD
	            	}
	            	cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
	                cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	            	table.addCell(cell);
	            	if(StringUtils.isNotEmpty(bean.getConvdesc())){
	            		cell = new PdfPCell(new Phrase(bean.getConvdesc(),fontnormalpeq));//NOPMD
	            		cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	            	}
	            	else{
	            		cell = new PdfPCell(new Phrase(""));//NOPMD
	            	}
	            	table.addCell(cell);
	            	if(StringUtils.isNotEmpty(bean.getTotalelectores())){
	            		totalElec = totalElec+Integer.parseInt(bean.getTotalelectores());
	            		cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(Integer.parseInt(bean.getTotalelectores())),fontnormalpeq));//NOPMD
	            	}
	            	else{
	            		cell = new PdfPCell(new Phrase(""));//NOPMD
	            	}
	            	cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	            	cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
	            	table.addCell(cell);
	            	if (W83aClsConstantes.codELA.equals(bean.getCodsindicato())){
	            		cell = new PdfPCell(new Phrase(""));//NOPMD
	        			//ELA
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalELA=totalELA+Integer.parseInt(bean.getNumdelegados());
	        				tELA=tELA+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
	        					cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(tELA),fontnormalpeq));//NOPMD
	    		            }
	        			}
	        			cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	        			cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
	        			table.addCell(cell);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        		}else if (W83aClsConstantes.codCCOO.equals(bean.getCodsindicato())){
	        			insertarCeldaVacia(table);
	        			cell = new PdfPCell(new Phrase(""));//NOPMD
	        			//CCOO
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalCCOO=totalCCOO+Integer.parseInt(bean.getNumdelegados());
	        				tCCOO=tCCOO+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
	        					cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(tCCOO),fontnormalpeq));//NOPMD
	        				}
	        			}
	        			cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	        			cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
	        			table.addCell(cell);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        		}else if (W83aClsConstantes.codUGT.equals(bean.getCodsindicato())){
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			cell = new PdfPCell(new Phrase(""));//NOPMD
	        			//UGT
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalUGT=totalUGT+Integer.parseInt(bean.getNumdelegados());
	        				tUGT=tUGT+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
	        					cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(tUGT),fontnormalpeq));//NOPMD
	        				}
	        			}
	        			cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	        			cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
	        			table.addCell(cell);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        		}else if (W83aClsConstantes.codLAB.equals(bean.getCodsindicato())){
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			cell = new PdfPCell(new Phrase(""));//NOPMD
	        			//LAB
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalLAB=totalLAB+Integer.parseInt(bean.getNumdelegados());
	        				tLAB=tLAB+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
	        					cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(tLAB),fontnormalpeq));//NOPMD
	        				}
	        			}
	        			cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	        			cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
	        			table.addCell(cell);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        		}else if (W83aClsConstantes.codUSO.equals(bean.getCodsindicato())){
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			cell = new PdfPCell(new Phrase(""));//NOPMD
	        			//USO
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalUSO=totalUSO+Integer.parseInt(bean.getNumdelegados());
	        				tUSO=tUSO+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
	        					cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(tUSO),fontnormalpeq));//NOPMD
	        				}
	        			}
	        			cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	        			cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
	        			table.addCell(cell);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        		}else if (W83aClsConstantes.codCUIS.equals(bean.getCodsindicato())){
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			cell = new PdfPCell(new Phrase(""));//NOPMD
	        			//CUIS
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalCUIS=totalCUIS+Integer.parseInt(bean.getNumdelegados());
	        				tCUIS=tCUIS+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
	        					cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(tCUIS),fontnormalpeq));//NOPMD
	        				}
	        			}
	        			cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	        			cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
	        			table.addCell(cell);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        		}else if (W83aClsConstantes.codCTI.equals(bean.getCodsindicato())){
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			cell = new PdfPCell(new Phrase(""));//NOPMD
	        			//CTI
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalCTS=totalCTS+Integer.parseInt(bean.getNumdelegados());
	        				tCTS=tCTS+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
	        					cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(tCTS),fontnormalpeq));//NOPMD
	        				}
	        			}
	        			cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	        			cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
	        			table.addCell(cell);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        		}else if (W83aClsConstantes.codCSI.equals(bean.getCodsindicato())){
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			cell = new PdfPCell(new Phrase(""));//NOPMD
	        			//CSI/CSI
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalCSI=totalCSI+Integer.parseInt(bean.getNumdelegados());
	        				tCSI=tCSI+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
	        					cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(tCSI),fontnormalpeq));//NOPMD
	        				}
	        			}
	        			cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	        			cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
	        			table.addCell(cell);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        		}else if (W83aClsConstantes.codNOSIN.equals(bean.getCodsindicato())){
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			cell = new PdfPCell(new Phrase(""));//NOPMD
	        			//NO SIN
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
	        				total=total+Integer.parseInt(bean.getNumdelegados());
	        				totalNOSIN=totalNOSIN+Integer.parseInt(bean.getNumdelegados());
	        				tNOSIN=tNOSIN+Integer.parseInt(bean.getNumdelegados());
	        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
	        					cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(tNOSIN),fontnormalpeq));//NOPMD
	        				}
	        			}
	        			cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	        			cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
	        			table.addCell(cell);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        		}else{
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			insertarCeldaVacia(table);
	        			cell = new PdfPCell(new Phrase(""));//NOPMD
	        			//OTROS
	        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
		        			otros=otros+Integer.parseInt(bean.getNumdelegados());
		        			total=total+Integer.parseInt(bean.getNumdelegados());
		        			totalOTROS=totalOTROS+Integer.parseInt(bean.getNumdelegados());
//	            			if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
		        				cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(otros),fontnormalpeq));//NOPMD
		        				cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
		        				cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
		        				table.addCell(cell);
//		        			}
	        			}else{
	        				otros=otros+0;
	            			total=total+0;
	            			totalOTROS=totalOTROS+0;
	        			}
	        			insertarCeldaVacia(table);
	        		}
	            	acta=bean.getNacta();
	            	anno=Integer.parseInt(bean.getAnoacta());
	            	contador=contador+1;
	            	
        	}else{
        		cells=(PdfPCell[])table.getRow(contador-1).getCells();
        		if (W83aClsConstantes.codELA.equals(bean.getCodsindicato())){
        			//ELA
        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalELA=totalELA+Integer.parseInt(bean.getNumdelegados());
        				tELA=tELA+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
        					cells[9].setPhrase(new Phrase(W83aUtilidades.separadorMiles(tELA),fontnormalpeq));//NOPMD
        				}
        			}
        		}else if (W83aClsConstantes.codCCOO.equals(bean.getCodsindicato())){
        			//CCOO
        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalCCOO=totalCCOO+Integer.parseInt(bean.getNumdelegados());
        				tCCOO=tCCOO+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
        					cells[10].setPhrase(new Phrase(W83aUtilidades.separadorMiles(tCCOO),fontnormalpeq));//NOPMD
        				}
        			}
        		}else if (W83aClsConstantes.codUGT.equals(bean.getCodsindicato())){
        			//UGT
					if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalUGT=totalUGT+Integer.parseInt(bean.getNumdelegados());
        				tUGT=tUGT+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
        					cells[11].setPhrase(new Phrase(W83aUtilidades.separadorMiles(tUGT),fontnormalpeq));//NOPMD
        				}
        			}
        		}else if (W83aClsConstantes.codLAB.equals(bean.getCodsindicato())){
        			//LAB
					if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalLAB=totalLAB+Integer.parseInt(bean.getNumdelegados());
        				tLAB=tLAB+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
        					cells[12].setPhrase(new Phrase(W83aUtilidades.separadorMiles(tLAB),fontnormalpeq));//NOPMD
        				}
        			}
        		}else if (W83aClsConstantes.codUSO.equals(bean.getCodsindicato())){
        			//USO
					if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalUSO=totalUSO+Integer.parseInt(bean.getNumdelegados());
        				tUSO=tUSO+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
        					cells[13].setPhrase(new Phrase(W83aUtilidades.separadorMiles(tUSO),fontnormalpeq));//NOPMD
        				}
        			}
        		}else if (W83aClsConstantes.codCUIS.equals(bean.getCodsindicato())){
        			//CUIS
					if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalCUIS=totalCUIS+Integer.parseInt(bean.getNumdelegados());
        				tCUIS=tCUIS+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
        					cells[14].setPhrase(new Phrase(W83aUtilidades.separadorMiles(tCUIS),fontnormalpeq));//NOPMD
        				}
        			}
        		}else if (W83aClsConstantes.codCTI.equals(bean.getCodsindicato())){
        			//CTI
					if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalCTS=totalCTS+Integer.parseInt(bean.getNumdelegados());
        				tCTS=tCTS+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
        					cells[15].setPhrase(new Phrase(W83aUtilidades.separadorMiles(tCTS),fontnormalpeq));//NOPMD
        				}
        			}
        		}else if (W83aClsConstantes.codCSI.equals(bean.getCodsindicato())){
        			//CSI/CSI
        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalCSI=totalCSI+Integer.parseInt(bean.getNumdelegados());
        				tCSI=tCSI+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
        					cells[16].setPhrase(new Phrase(W83aUtilidades.separadorMiles(tCSI),fontnormalpeq));//NOPMD
        				}
        			}
        		}else if (W83aClsConstantes.codNOSIN.equals(bean.getCodsindicato())){
        			//NO SIN
					if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				total=total+Integer.parseInt(bean.getNumdelegados());
        				totalNOSIN=totalNOSIN+Integer.parseInt(bean.getNumdelegados());
        				tNOSIN=tNOSIN+Integer.parseInt(bean.getNumdelegados());
        				if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
        					cells[17].setPhrase(new Phrase(W83aUtilidades.separadorMiles(tNOSIN),fontnormalpeq));//NOPMD
        				}
        			}
        		}else{ 
        			if(StringUtils.isNotEmpty(bean.getNumdelegados())){
        				otros=otros+Integer.parseInt(bean.getNumdelegados());
            			total=total+Integer.parseInt(bean.getNumdelegados());
            			totalOTROS=totalOTROS+Integer.parseInt(bean.getNumdelegados());
//            			if(0!=W83aUtilidades.numero(bean.getNumdelegados())){
            				cells[18].setPhrase(new Phrase(W83aUtilidades.separadorMiles(otros),fontnormalpeq));//NOPMD
//            			}
        			}else{
        				otros=otros+0;
            			total=total+0;
            			totalOTROS=totalOTROS+0;
        			}
        		}
        	}
        	}
        	if (i==lista.size()-1){
        		cells=(PdfPCell[])table.getRow(contador-1).getCells();
        		cells[19].setPhrase(new Phrase(W83aUtilidades.separadorMiles(total),fontnormalpeq));//NOPMD
        	}
        	
        }
        cell = new PdfPCell(new Phrase(String.valueOf("GUZTIRA/ TOTAL"),fontbold));
        cell.setColspan(8);
		table.addCell(cell);
        
		cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totalElec),fontbold));
		cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
		table.addCell(cell);
		cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totalELA),fontbold));
		cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
		table.addCell(cell);
		cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totalCCOO),fontbold));
		cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
		table.addCell(cell);
		cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totalUGT),fontbold));
		cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
		table.addCell(cell);
		cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totalLAB),fontbold));
		cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
		table.addCell(cell);
		cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totalUSO),fontbold));
		cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
		table.addCell(cell);
		cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totalCUIS),fontbold));
		cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
		table.addCell(cell);
		cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totalCTS),fontbold));
		cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
		table.addCell(cell);
		cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totalCSI),fontbold));
		cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
		table.addCell(cell);
		cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totalNOSIN),fontbold));
		cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
		table.addCell(cell);
		cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totalOTROS),fontbold));
		cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
		table.addCell(cell);
		int totalTotal = totalCCOO+totalCSI+totalCTS+totalCUIS+totalELA+totalLAB+totalNOSIN+totalOTROS+totalUGT+totalUSO;
		cell = new PdfPCell(new Phrase(W83aUtilidades.separadorMiles(totalTotal),fontbold));
		cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
		table.addCell(cell);

		document.add(table);
		
		document.close();
		
		W83aUtilidadesPdf.ponerCabecera(baos,provincia,idioma,"horizontal");
		
		OutputStream out = response.getOutputStream();	        
        baos.writeTo(out);
        out.flush();			
	    out.close();
		
    	return null;

}
	
	public void insertarCeldaVacia(PdfPTable table){
		PdfPCell cell = new PdfPCell(new Phrase(""));
		cell.setHorizontalAlignment(Rectangle.ALIGN_RIGHT);
		cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
		table.addCell(cell);
	}
	public void estiloCabecera(PdfPCell cell){
		cell.setHorizontalAlignment(Rectangle.ALIGN_CENTER);
	    cell.setVerticalAlignment(Rectangle.ALIGN_MIDDLE);
	    cell.setBackgroundColor(new Color(204,204,204));//NOPMD
	}
	
}
